PKG_PATH="$(dirname "$0")/Lightroom"
LR_PATH="Library/Application Support/Adobe/Lightroom"
MOD_PATH="$LR_PATH/Modules/"
PRESET_PATH="$LR_PATH/Export Presets/"
PRESET_PATH_2="Pictures/Lightroom/Lightroom Settings/Export Presets/"
BIN_PATH="mergeraw.lrplugin/mergeraw-mac64"
PLEASE="Please try the Manual Installation instructions in INSTALL.rtf."
ERROR="ERROR:"
VERBOSE=

echo "Removing old versions of the plugin... \c"

if [ -d ~/"$PRESET_PATH" ]; then
  rm $VERBOSE -df -r ~/"$PRESET_PATH/Merge Raw Files/Merge Raw Files.lrtemplate" ~/"$PRESET_PATH/Merge Raw Files"
  rm $VERBOSE -df -r ~/"$PRESET_PATH/Remove Built-in Profile/Remove Built-in Profile.lrtemplate" ~/"$PRESET_PATH/Remove Built-in Profile"
  rm $VERBOSE -df -r ~/"$PRESET_PATH/Edit Raw File in Photoshop/Edit Raw File in Photoshop.lrtemplate" ~/"$PRESET_PATH/Edit Raw File in Photoshop"
fi

if [ -d ~/"$PRESET_PATH_2" ]; then
  rm $VERBOSE -df -r ~/"$PRESET_PATH_2/Merge Raw Files/Merge Raw Files.lrtemplate" ~/"$PRESET_PATH/Merge Raw Files"
  rm $VERBOSE -df -r ~/"$PRESET_PATH_2/Remove Built-in Profile/Remove Built-in Profile.lrtemplate" ~/"$PRESET_PATH/Remove Built-in Profile"
  rm $VERBOSE -df -r ~/"$PRESET_PATH_2/Edit Raw File in Photoshop/Edit Raw File in Photoshop.lrtemplate" ~/"$PRESET_PATH/Edit Raw File in Photoshop"
fi


if [ -d ~/"$MOD_PATH" ]; then

  rm $VERBOSE -df ~/"$MOD_PATH"/mergeraw.lrplugin/* ~/"$MOD_PATH"/mergeraw.lrplugin
  rm $VERBOSE -df ~/"$MOD_PATH"/rmprof.lrplugin/* ~/"$MOD_PATH"/rmprof.lrplugin
  rm $VERBOSE -df ~/"$MOD_PATH"/editraw.lrplugin/* ~/"$MOD_PATH"/editraw.lrplugin
  echo "OK\n"

  echo "Installing Ryan's Raw Tools into user Lightroom plugin directory (~/$MOD_PATH)... \c"
  if ! cp $VERBOSE -r $PKG_PATH/mergeraw.lrplugin ~/"$MOD_PATH"; then
    echo "\n$ERROR Failed copying plugin. $PLEASE"; exit 1
  fi
  echo "OK\n"

elif [ -d "/$MOD_PATH" ]; then

  rm $VERBOSE -df /"$MOD_PATH"/mergeraw.lrplugin/* /"$MOD_PATH"/mergeraw.lrplugin
  rm $VERBOSE -df /"$MOD_PATH"/rmprof.lrplugin/* /"$MOD_PATH"/rmprof.lrplugin
  rm $VERBOSE -df /"$MOD_PATH"/editraw.lrplugin/* /"$MOD_PATH"/editraw.lrplugin
  echo "OK\n"

  echo "Installing Ryan's Raw Tools into system-wide Lightroom plugin directory (/$MOD_PATH)... \c"
  if ! cp $VERBOSE -r $PKG_PATH/mergeraw.lrplugin "/$MOD_PATH"; then
    echo "\n$ERROR Failed copying plugin. $PLEASE"; exit 1
  fi
  echo "OK\n"

elif [ -d ~/"$LR_PATH" ]; then

  echo "Creating Lightroom Plugin directory (~/$MOD_PATH)"

  mkdir -p ~/"$MOD_PATH"

  if [ -d ~/"$MOD_PATH" ]; then

    echo "Installing Ryan's Raw Tools into user Lightroom plugin directory (~/$MOD_PATH)... \c"
    if ! cp $VERBOSE -r $PKG_PATH/mergeraw.lrplugin ~/"$MOD_PATH"; then
      echo "\n$ERROR Failed copying plugin. $PLEASE"; exit 1
    fi
    echo "OK\n"

  else

    echo "Unable to create Lightroom Plugin directory. $PLEASE"
    exit 1

  fi

elif [ -d /"$LR_PATH" ]; then

  echo "Creating Lightroom Plugin directory (/$MOD_PATH)"

  mkdir -p /"$MOD_PATH"

  if [ -d /"$MOD_PATH" ]; then

    echo "Installing Ryan's Raw Tools into system-wide Lightroom plugin directory (/$MOD_PATH)... \c"
    if ! cp $VERBOSE -r $PKG_PATH/mergeraw.lrplugin "/$MOD_PATH"; then
      echo "\n$ERROR Failed copying plugin. $PLEASE"; exit 1
    fi
    echo "OK\n"

  else

    echo "Unable to create Lightroom Plugin directory. $PLEASE"
    exit 1

  fi

else

  echo "Unable to identify Lightroom Plugin directory location. $PLEASE"
  exit 1

fi

if [ -d ~/"$MOD_PATH" ]; then
  ~/"$MOD_PATH"$BIN_PATH -v || echo "$ERROR Unable to run $BIN_PATH. $PLEASE"
elif [ -d "/$MOD_PATH" ]; then
  "/$MOD_PATH"$BIN_PATH -v || echo "$ERROR Unable to run $BIN_PATH. $PLEASE"
fi

echo "\nInstallation appears successful. You may close this window and restart Lightroom."
