--[[----------------------------------------------------------------------------

   MergeRawConfig.lua

   Configuration settings for Ryan's Raw Tools plugin.
   Contains debug flags, Photoshop path configuration, and metadata
   field definitions for inheritance during photo processing.

   Copyright (c) 2019-2025 Ryan Mack

----------------------------------------------------------------------------]]

MergeRawConfig = {
   Debug = true,

   -- Photoshop path (leave empty '' to auto-detect)
   -- Auto-detection priority:
   --   1. Currently running Photoshop instance
   --   2. Newest version in /Applications folder
   --   3. Default fallback location
   -- Or set explicitly, e.g.:
   -- PhotoshopAppPath = '/Applications/Adobe Photoshop 2026/Adobe Photoshop 2026.app',
   PhotoshopAppPath = '',

--
-- All metadata fields that can be copied (based on SDK docs)
--
   
   MetadataFieldsToInherit = {
      'additionalModelInfo',
      'altTextAccessibility',
      'artworksShown',
      'caption',
      'city',
      'codeOfOrgShown',
      'colorNameForLabel',
      'copyName',
      'copyright',
      'copyrightInfoUrl',
      'copyrightOwner',
      'copyrightState',
      'country',
      'creator',
      'creatorAddress',
      'creatorCity',
      'creatorCountry',
      'creatorEmail',
      'creatorJobTitle',
      'creatorPhone',
      'creatorPostalCode',
      'creatorStateProvince',
      'creatorUrl',
      'dateCreated',
      'descriptionWriter',
      'event',
      'extDescrAccessibility',
      'gps',
      'gpsAltitude',
      'gpsImgDirection',
      'headline',
      'imageCreator',
      'imageSupplier',
      'imageSupplierImageId',
      'instructions',
      'intellectualGenre',
      'iptcCategory',
      'iptcOtherCategories',
      'iptcSubjectCode',
      'isoCountryCode',
      'jobIdentifier',
      'label',
      'licensor',
      'location',
      'locationCreated',
      'locationIsPrivate',
      'locationShown',
      'maxAvailHeight',
      'maxAvailWidth',
      'minorModelAge',
      'modelAge',
      'modelReleaseID',
      'modelReleaseStatus',
      'nameOfOrgShown',
      'personShown',
      'pickStatus',
      'propertyReleaseID',
      'propertyReleaseStatus',
      'provider',
      'rating',
      'registryId',
      'rightsUsageTerms',
      'scene',
      'source',
      'sourceType',
      'stateProvince',
      'title'
   }
}
